#!/bin/bash
BASEDIR=$(dirname $0)
echo searching for Info.plist to update...

function update_file
{
    if [ -f $1.tmp ]; then
        rm -f $1.tmp
    fi
	bash $BASEDIR/update_ifd_ccid_bundle.sh "$1" "$2" "$3" "$4" > "$1.tmp"
    rm -f "$1"
    mv "$1.tmp" "$1"
}

for file in $(find /usr/lib* /usr/local -name "Info.plist" | grep "ifd-ccid.bundle/Contents" ); do
	NOW=$(date +%d-%m-%y-%T)
	# Get source file if @Info.plist - symbolic link
	file=`readlink -e $file`
	if [ "$?" -eq 1 ]; then
		continue
	fi

	cp -f ${file} ${file}.$NOW.backup
	echo checking $file
	bash $BASEDIR/check_plist_integrity.sh ${file}
    checkStatus=$?
	if [ "$checkStatus" -eq 2 ]; then
        echo replacing broken ${file} with no-device-plist
        cp -fv $BASEDIR/NoDeviceInfo.plist ${file}
	fi
	if [ "$checkStatus" -eq 1 ]; then
        echo incorrect ${file} exitting
        exit 1
	fi
	cp -f ${file} ${file}.orig
	WORK_FILE=${file}.orig
	echo updating $file
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*ARDS.*</string>' "$WORK_FILE"
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*Aladdin.*</string>' "$WORK_FILE"
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*JaCarta.*</string>' "$WORK_FILE"
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*JC-STM.*</string>' "$WORK_FILE"
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*JCR-770.*</string>' "$WORK_FILE"
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*JCR 7XX series.*</string>' "$WORK_FILE"
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*JCR721.*</string>' "$WORK_FILE"
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*JCR761.*</string>' "$WORK_FILE"
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*bR301.*</string>' "$WORK_FILE"
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*iR301.*</string>' "$WORK_FILE"
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*ASEDrive III.*</string>' "$WORK_FILE"
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*eToken PRO Java 72K OS755.*</string>' "$WORK_FILE"
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*HP Model KU0133.*</string>' "$WORK_FILE"
	bash $BASEDIR/remove_by_friendly_name.sh '<string>.*ACR38U-I1.*</string>' "$WORK_FILE"

	update_file "$WORK_FILE" "0x24DC" "0x0101" "Aladdin R.D. JaCarta"
	update_file "$WORK_FILE" "0x24DC" "0x0102" "Aladdin R.D. JaCarta LT"
	update_file "$WORK_FILE" "0x24DC" "0x0201" "Aladdin R.D. JCR-770"
	update_file "$WORK_FILE" "0x24DC" "0x0401" "Aladdin R.D. JaCarta WebPass"
	update_file "$WORK_FILE" "0x24DC" "0x0402" "Aladdin R.D. JaCarta"
	update_file "$WORK_FILE" "0x24DC" "0x0406" "Aladdin R.D. JaCarta SF GOST"
	update_file "$WORK_FILE" "0x24DC" "0x0407" "Aladdin R.D. JaCarta U2F/WebPass(JC603)"
	update_file "$WORK_FILE" "0x24DC" "0x0409" "Aladdin R.D. JaCarta-2 SF"
	update_file "$WORK_FILE" "0x24DC" "0x040A" "JC-STM"
	update_file "$WORK_FILE" "0x24DC" "0x040B" "Aladdin R.D. JF"
	update_file "$WORK_FILE" "0x24DC" "0x040C" "Aladdin R.D. LO"
	update_file "$WORK_FILE" "0x24DC" "0x040D" "Aladdin R.D. JaCarta SF"
	update_file "$WORK_FILE" "0x24DC" "0x0420" "Aladdin R.D. JCR SecurBio"
	update_file "$WORK_FILE" "0x24DC" "0x0421" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x0422" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x0423" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x0424" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x0425" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x0426" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x0427" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x0428" "Aladdin R.D. JCR"
	update_file "$WORK_FILE" "0x24DC" "0x0429" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x042A" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x042B" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x042C" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x042D" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x042E" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x042F" "JCR 7XX series"
	update_file "$WORK_FILE" "0x24DC" "0x0432" "JCR761"
	update_file "$WORK_FILE" "0x24DC" "0x04FF" "Aladdin R.D. JaCarta SF GOST"
	update_file "$WORK_FILE" "0x24DC" "0x0501" "Aladdin R.D. JaCarta U2F (JC602)"
	update_file "$WORK_FILE" "0x24DC" "0x100F" "Aladdin R.D. JaCarta Flash"
	update_file "$WORK_FILE" "0x0529" "0x0600" "Aladdin R.D. JaCarta Anywhere"
	update_file "$WORK_FILE" "0x0529" "0x0620" "eToken PRO Java 72K OS755"
	update_file "$WORK_FILE" "0x0529" "0x0700" "Aladdin R.D. NG-OTP 72k"
	update_file "$WORK_FILE" "0x096E" "0x061A" "bR301"
	update_file "$WORK_FILE" "0x096E" "0x061C" "iR301"
	update_file "$WORK_FILE" "0x096E" "0x0619" "iR301"
	update_file "$WORK_FILE" "0x0DC3" "0x1004" "ASEDrive III USB V2C"
	update_file "$WORK_FILE" "0x0DC3" "0x0802" "ASEDrive IIIe USB"
	update_file "$WORK_FILE" "0x0DC3" "0x1104" "ASEDrive IIIe KB"
	update_file "$WORK_FILE" "0x03F0" "0x0036" "HP Model KU0133"
	update_file "$WORK_FILE" "0x072F" "0x90CC" "ACR38U-I1"
	
	echo checking updated $file
	bash $BASEDIR/check_plist_integrity.sh "$WORK_FILE"
	if [ "$?" -eq 1 ]; then
        rm -f "$WORK_FILE"
		exit 1
	fi
	
	chown --reference=${file} "$WORK_FILE"
	chmod --reference=${file} "$WORK_FILE"
	rm -f ${file}
    mv "$WORK_FILE" ${file}
done
